require( "HiddenObject/Script/style.lua" );

ButtonGraphics_Pause = {
	"Concentration/UI/Button/pausenormal",
	"Concentration/UI/Button/pausemousedown",
	"Concentration/UI/Button/pausemouseover"
};


ButtonStyle_Pause = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = ButtonGraphics_Pause,
};

ButtonGraphics_Pause_Disabled = {
	"Concentration/UI/Button/pausenormal",
};


ButtonStyle_Pause_Disabled = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = ButtonGraphics_Pause_Disabled,
};


ButtonGraphics_Skip = {
	"Concentration/UI/Button/skipnormal",
	"Concentration/UI/Button/skipmousedown",
	"Concentration/UI/Button/skipmouseover"
};


ButtonStyle_Skip = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = ButtonGraphics_Skip,
};


ButtonGraphics_Skip_Disabled = {
	"Concentration/UI/Button/skipnormal",
};


ButtonStyle_Skip_Disabled = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = ButtonGraphics_Skip_Disabled,
};

ButtonStyle_Hint = {
	parent = DefaultStyle,
	type= kPush,
	graphics = ButtonGraphics_Skip,
};

FooterMenuGraphics = {
	"Concentration/UI/Button/okmousenormal",
	"Concentration/UI/Button/okmousedown",
	"Concentration/UI/Button/okmouseover"
};

FooterMenuStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterMenuGraphics,
	flags = kVAlignCenter + kHAlignCenter,
}

FooterHintGraphics = {
	"Concentration/UI/Button/hintnormal",
};

FooterNoGraphics = {
	"Concentration/UI/Button/nomousenormal",
	"Concentration/UI/Button/nomousedown",
	"Concentration/UI/Button/nomouseover"
};

FooterNoStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterNoGraphics,
	flags = kVAlignCenter + kHAlignCenter,
}

FooterYesGraphics = {
	"Concentration/UI/Button/yesmousenormal",
	"Concentration/UI/Button/yesmousedown",
	"Concentration/UI/Button/yesmouseover"
};

FooterYesStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterYesGraphics,
	flags = kVAlignCenter + kHAlignCenter,
}


ConcentrationButtonFont = {
  standardFont,
  28,
  WhiteColor
};


MakeDialog
{
	-- Name the modal dialog
	name="ConcentrationWindow",
	Bitmap
	{
		name="ConcentraionWindowBackgroundImage",
		image="Concentration/Image/background",
		x = 0,
		y = 0,
		w = 800,
		h = 600,			
			
		ConcentrationWindow
		{
			x=0,
			y=0,
			w=800,
			h=600,
			
			SetStyle(ButtonStyle_Skip);
			Button
			{
				x=655,
				y=543,
				font = ConcentrationButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="skip",
				label="skip",
				type = kPush,
				command=
					function()
						if IsWindowActive() then
							--DoModal("HiddenObject/script/skip.lua");
							SendGameMessage('activateSkip');
						end
					end
			},
			SetStyle(ButtonStyle_Skip_Disabled);
			Button
			{
				x=655,
				y=543,
				font = ConcentrationButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="skip_Disabled",
				label="skip",
				type = kPush,
				command=
					function()
					end
			},
			
			SetStyle(ButtonStyle_Hint);
			Button
			{
				x=560,
				y=543,
				name="hint",
				label="hint",
				font = ConcentrationButtonFont,
				graphics = FooterHintGraphics,
			},
			
			SetStyle(ButtonStyle_Pause);
			Button
			{
				x=420,
				y=543,
				font = ConcentrationButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="pause",
				label="pause",
				type = kPush,
				command=
					function()
						if IsWindowActive() then
							SendGameMessage("unpause");
							SendGameMessage("pause");
							--DoModal('HiddenObject/script/pause.lua');
						end
					end
			},
			SetStyle(ButtonStyle_Pause_Disabled);
			Button
			{
				x=420,
				y=543,
				font = ConcentrationButtonFont,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="pause_Disabled",
				label="pause",
				type = kPush,
				command=
					function()
					end
			},
			
			SetStyle(FooterYesStyle);
			Button
			{
				x=247,
				y=380,
				font = FooterMenuButtonFont,
				graphics = FooterYesGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="retry_yes",
				label="yes",
				type = kPush,
				command=
					function()
						EnableWindow( "retry_yes", false);
						EnableWindow( "retry_no", false);
						EnableWindow( "skip", true);
						EnableWindow( "pause", true);	
						EnableWindow( "skip_Disabled", false);
						EnableWindow( "pause_Disabled", false);
						SendGameMessage("retry");
					end
			},
			SetStyle(FooterYesStyle);
			Button
			{
				x=412,
				y=380,
				font = FooterMenuButtonFont,
				graphics = FooterYesGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="retry_no",
				label="no",
				type = kPush,
				command=
					function()
						EnableWindow( "retry_yes", false);
						EnableWindow( "retry_no", false);
						EnableWindow( "skip", false);
						EnableWindow( "pause", false);
						EnableWindow( "ok", false);
						EnableWindow( "hint", false);
						EnableWindow( "skip_Disabled", false);
						EnableWindow( "pause_Disabled", false);
						SendGameMessage("next");
					end
			},
			
			SetStyle(FooterMenuStyle);
			Button
			{
				x=260,
				y=330,
				font = FooterMenuButtonFont,
				graphics = FooterMenuGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="rebus_ok",
				label="ok",
				type = kPush,
				command=
					function()
						EnableWindow( "rebus_ok", false);	
						EnableWindow( "skip", true);
						EnableWindow( "pause", true);	
						EnableWindow( "skip_Disabled", false);
						EnableWindow( "pause_Disabled", false);
						SendGameMessage("rebus");
					end
			},
				
			SetStyle(FooterMenuStyle);
			Button
			{
				x=255,
				y=320,
				font = FooterMenuButtonFont,
				graphics = FooterMenuGraphics,
				sound = kDefaultButtonSound,
				rolloversound = kDefaultButtonOverSound,
				name="ok",
				label="ok",
				type = kPush,
				command=
					function()
						EnableWindow( "ok", false);
						EnableWindow( "skip", true);
						EnableWindow( "pause", true);	
						EnableWindow( "skip_Disabled", false);
						EnableWindow( "pause_Disabled", false);	
						SendGameMessage("ok");
					end
			},	
		},	
	},
}

EnableWindow( "retry_yes", false);
EnableWindow( "retry_no", false);
EnableWindow( "pause", false);
EnableWindow( "skip", false);
EnableWindow( "ok", false);
EnableWindow( "rebus_ok", false);
EnableWindow( "hint", false);
EnableWindow( "skip_Disabled", false);
EnableWindow( "pause_Disabled", false);
SetFocus( "ConcentrationWindow" );	